import { Component, EventEmitter, Injector, Input, Output, } from '@angular/core';
import { DynamicComponentInjectorToken, } from './component-injector';
import * as i0 from "@angular/core";
/**
 * @public
 */
export class DynamicComponent {
    constructor(vcr) {
        this.vcr = vcr;
        this.ndcDynamicCreated = new EventEmitter();
        this.componentRef = null;
    }
    ngOnChanges(changes) {
        if (DynamicComponent.UpdateOnInputs.some((input) => changes.hasOwnProperty(input))) {
            this.createDynamicComponent();
        }
    }
    createDynamicComponent() {
        this.vcr.clear();
        this.componentRef = null;
        if (this.ndcDynamicComponent) {
            this.componentRef = this.vcr.createComponent(this.ndcDynamicComponent, {
                index: 0,
                injector: this._resolveInjector(),
                projectableNodes: this.ndcDynamicContent,
                ngModuleRef: this.ndcDynamicNgModuleRef,
                environmentInjector: this.ndcDynamicEnvironmentInjector,
            });
            this.ndcDynamicCreated.emit(this.componentRef);
        }
    }
    _resolveInjector() {
        let injector = this.ndcDynamicInjector || this.vcr.injector;
        if (this.ndcDynamicProviders) {
            injector = Injector.create({
                providers: this.ndcDynamicProviders,
                parent: injector,
            });
        }
        return injector;
    }
}
DynamicComponent.UpdateOnInputs = [
    'ndcDynamicComponent',
    'ndcDynamicInjector',
    'ndcDynamicProviders',
    'ndcDynamicContent',
    'ndcDynamicNgModuleRef',
    'ndcDynamicEnvironmentInjector',
];
/** @nocollapse */ DynamicComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: DynamicComponent, deps: [{ token: i0.ViewContainerRef }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ DynamicComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.1.3", type: DynamicComponent, isStandalone: true, selector: "ndc-dynamic", inputs: { ndcDynamicComponent: "ndcDynamicComponent", ndcDynamicInjector: "ndcDynamicInjector", ndcDynamicProviders: "ndcDynamicProviders", ndcDynamicContent: "ndcDynamicContent", ndcDynamicNgModuleRef: "ndcDynamicNgModuleRef", ndcDynamicEnvironmentInjector: "ndcDynamicEnvironmentInjector" }, outputs: { ndcDynamicCreated: "ndcDynamicCreated" }, providers: [
        { provide: DynamicComponentInjectorToken, useExisting: DynamicComponent },
    ], usesOnChanges: true, ngImport: i0, template: '', isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: DynamicComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'ndc-dynamic',
                    standalone: true,
                    template: '',
                    providers: [
                        { provide: DynamicComponentInjectorToken, useExisting: DynamicComponent },
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.ViewContainerRef }]; }, propDecorators: { ndcDynamicComponent: [{
                type: Input
            }], ndcDynamicInjector: [{
                type: Input
            }], ndcDynamicProviders: [{
                type: Input
            }], ndcDynamicContent: [{
                type: Input
            }], ndcDynamicNgModuleRef: [{
                type: Input
            }], ndcDynamicEnvironmentInjector: [{
                type: Input
            }], ndcDynamicCreated: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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