import { Injectable, Injector } from '@angular/core';
import { DynamicComponentInjectorToken, } from '../component-injector';
import { IoService, IoServiceOptions } from './io.service';
import * as i0 from "@angular/core";
/**
 * @public
 */
export class IoFactoryService {
    constructor(injector) {
        this.injector = injector;
    }
    create(componentInjector, ioOptions) {
        const providers = [
            { provide: IoService, useClass: IoService },
            { provide: DynamicComponentInjectorToken, useValue: componentInjector },
        ];
        if (ioOptions) {
            providers.push({ provide: IoServiceOptions, useValue: ioOptions });
        }
        const ioInjector = Injector.create({
            name: 'IoInjector',
            parent: ioOptions?.injector ?? this.injector,
            providers,
        });
        return ioInjector.get(IoService);
    }
}
/** @nocollapse */ IoFactoryService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoFactoryService, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ IoFactoryService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoFactoryService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoFactoryService, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
//# sourceMappingURL=data:application/json;base64,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