import { Inject, Injectable, Injector, Optional, } from '@angular/core';
import { Subject } from 'rxjs';
import { takeUntil } from 'rxjs/operators';
import { DynamicComponentInjectorToken, } from '../component-injector';
import { IoEventArgumentToken } from './event-argument';
import { IoEventContextProviderToken, IoEventContextToken, } from './event-context';
import * as i0 from "@angular/core";
/**
 * @public
 */
export class IoServiceOptions {
    constructor() {
        this.trackOutputChanges = false;
    }
}
/** @nocollapse */ IoServiceOptions.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoServiceOptions, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ IoServiceOptions.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoServiceOptions, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoServiceOptions, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }] });
/**
 * @public
 */
export class IoService {
    constructor(injector, differs, 
    // TODO: Replace ComponentFactoryResolver once new API is created
    // @see https://github.com/angular/angular/issues/44926
    // eslint-disable-next-line deprecation/deprecation
    cfr, options, compInjector, eventArgument, cdr, eventContextProvider) {
        this.injector = injector;
        this.differs = differs;
        this.cfr = cfr;
        this.options = options;
        this.compInjector = compInjector;
        this.eventArgument = eventArgument;
        this.cdr = cdr;
        this.eventContextProvider = eventContextProvider;
        this.lastComponentInst = null;
        this.lastChangedInputs = new Set();
        this.inputsDiffer = this.differs.find({}).create();
        // TODO: Replace ComponentFactory once new API is created
        // @see https://github.com/angular/angular/issues/44926
        // eslint-disable-next-line deprecation/deprecation
        this.compFactory = null;
        this.outputsShouldDisconnect$ = new Subject();
        this.inputs = {};
        this.outputs = {};
        this.outputsChanged = () => false;
        if (this.options.trackOutputChanges) {
            const outputsDiffer = this.differs.find({}).create();
            this.outputsChanged = (outputs) => !!outputsDiffer.diff(outputs);
        }
    }
    get compRef() {
        return this.compInjector.componentRef;
    }
    get componentInst() {
        return this.compRef ? this.compRef.instance : null;
    }
    get componentInstChanged() {
        if (this.lastComponentInst !== this.componentInst) {
            this.lastComponentInst = this.componentInst;
            return true;
        }
        else {
            return false;
        }
    }
    ngOnDestroy() {
        this.disconnectOutputs();
    }
    /**
     * Call update whenever inputs/outputs may or did change.
     *
     * It will detect both new and mutated changes.
     */
    update(inputs, outputs) {
        if (!this.compRef) {
            this.disconnectOutputs();
            return;
        }
        const changes = this.updateIO(inputs, outputs);
        const compChanged = this.componentInstChanged;
        const inputsChanges = this.getInputsChanges(compChanged);
        const outputsChanged = this.outputsChanged(this.outputs);
        if (inputsChanges) {
            this.updateChangedInputs(inputsChanges);
        }
        if (compChanged || inputsChanges) {
            this.updateInputs(compChanged || !this.lastChangedInputs.size);
        }
        if (compChanged || outputsChanged || changes.outputsChanged) {
            this.bindOutputs();
        }
    }
    updateIO(inputs, outputs) {
        if (!inputs) {
            inputs = {};
        }
        if (!outputs) {
            outputs = {};
        }
        const inputsChanged = this.inputs !== inputs;
        const outputsChanged = this.outputs !== outputs;
        this.inputs = inputs;
        this.outputs = outputs;
        return { inputsChanged, outputsChanged };
    }
    updateInputs(isFirstChange = false) {
        if (isFirstChange) {
            this.updateCompFactory();
        }
        const compRef = this.compRef;
        const inputs = this.inputs;
        if (!inputs || !compRef) {
            return;
        }
        const ifInputChanged = this.lastChangedInputs.size
            ? (name) => this.lastChangedInputs.has(name)
            : () => true;
        Object.keys(inputs)
            .filter(ifInputChanged)
            .forEach((name) => compRef.setInput(name, inputs[name]));
    }
    bindOutputs() {
        this.disconnectOutputs();
        const compInst = this.componentInst;
        let outputs = this.outputs;
        if (!outputs || !compInst) {
            return;
        }
        outputs = this.resolveOutputs(outputs);
        Object.keys(outputs)
            .filter((p) => compInst[p])
            .forEach((p) => compInst[p]
            .pipe(takeUntil(this.outputsShouldDisconnect$))
            .subscribe((event) => {
            this.cdr.markForCheck();
            return outputs[p](event);
        }));
    }
    disconnectOutputs() {
        this.outputsShouldDisconnect$.next();
    }
    getInputsChanges(isCompChanged) {
        if (isCompChanged) {
            this.inputsDiffer.diff({});
        }
        return this.inputsDiffer.diff(this.inputs);
    }
    updateChangedInputs(differ) {
        this.lastChangedInputs.clear();
        const addRecordKeyToSet = (record) => this.lastChangedInputs.add(record.key);
        differ.forEachAddedItem(addRecordKeyToSet);
        differ.forEachChangedItem(addRecordKeyToSet);
        differ.forEachRemovedItem(addRecordKeyToSet);
    }
    // TODO: Replace ComponentFactory once new API is created
    // @see https://github.com/angular/angular/issues/44926
    // eslint-disable-next-line deprecation/deprecation
    resolveCompFactory() {
        if (!this.compRef) {
            return null;
        }
        try {
            try {
                return this.cfr.resolveComponentFactory(this.compRef.componentType);
            }
            catch (e) {
                // Fallback if componentType does not exist (happens on NgComponentOutlet)
                return this.cfr.resolveComponentFactory(this.compRef.instance.constructor);
            }
        }
        catch (e) {
            // Factory not available - bailout
            return null;
        }
    }
    updateCompFactory() {
        this.compFactory = this.resolveCompFactory();
    }
    resolveOutputs(outputs) {
        this.updateOutputsEventContext();
        outputs = this.processOutputs(outputs);
        if (!this.compFactory) {
            return outputs;
        }
        return this.remapIO(outputs, this.compFactory.outputs);
    }
    updateOutputsEventContext() {
        if (this.eventContextProvider) {
            // Resolve custom context from local provider
            const eventContextInjector = Injector.create({
                name: 'EventContext',
                parent: this.injector,
                providers: [this.eventContextProvider],
            });
            this.outputsEventContext = eventContextInjector.get(IoEventContextToken);
        }
        else {
            // Try to get global context
            this.outputsEventContext = this.injector.get(IoEventContextToken, null);
        }
    }
    processOutputs(outputs) {
        const processedOutputs = {};
        Object.keys(outputs).forEach((key) => {
            const outputExpr = outputs[key];
            let outputHandler;
            if (typeof outputExpr === 'function') {
                outputHandler = outputExpr;
            }
            else {
                outputHandler = outputExpr && this.processOutputArgs(outputExpr);
            }
            if (this.outputsEventContext && outputHandler) {
                outputHandler = outputHandler.bind(this.outputsEventContext);
            }
            processedOutputs[key] = outputHandler;
        });
        return processedOutputs;
    }
    processOutputArgs(output) {
        const eventArgument = this.eventArgument;
        const args = 'args' in output ? output.args || [] : [eventArgument];
        const eventIdx = args.indexOf(eventArgument);
        const handler = output.handler;
        // When there is no event argument - use just arguments
        if (eventIdx === -1) {
            return function () {
                return handler.apply(this, args);
            };
        }
        return function (event) {
            const argsWithEvent = [...args];
            argsWithEvent[eventIdx] = event;
            return handler.apply(this, argsWithEvent);
        };
    }
    remapIO(io, mapping) {
        const newIO = {};
        Object.keys(io).forEach((key) => {
            const newKey = this.findPropByTplInMapping(key, mapping) || key;
            newIO[newKey] = io[key];
        });
        return newIO;
    }
    findPropByTplInMapping(tplName, mapping) {
        for (const map of mapping) {
            if (map.templateName === tplName) {
                return map.propName;
            }
        }
        return null;
    }
}
/** @nocollapse */ IoService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoService, deps: [{ token: i0.Injector }, { token: i0.KeyValueDiffers }, { token: i0.ComponentFactoryResolver }, { token: IoServiceOptions }, { token: DynamicComponentInjectorToken }, { token: IoEventArgumentToken }, { token: i0.ChangeDetectorRef }, { token: IoEventContextProviderToken, optional: true }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ IoService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: IoService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i0.Injector }, { type: i0.KeyValueDiffers }, { type: i0.ComponentFactoryResolver }, { type: IoServiceOptions }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [IoEventArgumentToken]
                }] }, { type: i0.ChangeDetectorRef }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [IoEventContextProviderToken]
                }, {
                    type: Optional
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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