/**
 * Extract type arguments from Angular Directive/Component
 *
 * @internal
 */
export function extractNgParamTypes(type) {
    // NOTE: Accessing private APIs of Angular
    return type?.ctorParameters?.()?.map((param) => param.type);
}
/**
 * @internal
 */
export function isOnDestroy(obj) {
    return !!obj && typeof obj.ngOnDestroy === 'function';
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3Byb2plY3RzL25nLWR5bmFtaWMtY29tcG9uZW50L3NyYy9saWIvdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFFQTs7OztHQUlHO0FBQ0gsTUFBTSxVQUFVLG1CQUFtQixDQUNqQyxJQUFtQjtJQUVuQiwwQ0FBMEM7SUFDMUMsT0FBUSxJQUFZLEVBQUUsY0FBYyxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUMsQ0FBQyxLQUFVLEVBQUUsRUFBRSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUM1RSxDQUFDO0FBRUQ7O0dBRUc7QUFDSCxNQUFNLFVBQVUsV0FBVyxDQUFDLEdBQVk7SUFDdEMsT0FBTyxDQUFDLENBQUMsR0FBRyxJQUFJLE9BQVEsR0FBaUIsQ0FBQyxXQUFXLEtBQUssVUFBVSxDQUFDO0FBQ3ZFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBPbkRlc3Ryb3ksIFR5cGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuLyoqXG4gKiBFeHRyYWN0IHR5cGUgYXJndW1lbnRzIGZyb20gQW5ndWxhciBEaXJlY3RpdmUvQ29tcG9uZW50XG4gKlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBleHRyYWN0TmdQYXJhbVR5cGVzKFxuICB0eXBlOiBUeXBlPHVua25vd24+LFxuKTogdW5rbm93bltdIHwgdW5kZWZpbmVkIHtcbiAgLy8gTk9URTogQWNjZXNzaW5nIHByaXZhdGUgQVBJcyBvZiBBbmd1bGFyXG4gIHJldHVybiAodHlwZSBhcyBhbnkpPy5jdG9yUGFyYW1ldGVycz8uKCk/Lm1hcCgocGFyYW06IGFueSkgPT4gcGFyYW0udHlwZSk7XG59XG5cbi8qKlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBpc09uRGVzdHJveShvYmo6IHVua25vd24pOiBvYmogaXMgT25EZXN0cm95IHtcbiAgcmV0dXJuICEhb2JqICYmIHR5cGVvZiAob2JqIGFzIE9uRGVzdHJveSkubmdPbkRlc3Ryb3kgPT09ICdmdW5jdGlvbic7XG59XG4iXX0=