import { ChangeDetectorRef, DoCheck, ElementRef, EventEmitter, Injector, IterableDiffers, OnDestroy, Type, ViewRef } from '@angular/core';
import { DynamicComponentInjector } from '../component-injector';
import { InputsType, IoFactoryService, OutputsType } from '../io';
import { ReflectService } from '../reflect';
import * as i0 from "@angular/core";
/**
 * @public
 */
export interface DynamicDirectiveDef<T> {
    type: Type<T>;
    inputs?: InputsType;
    outputs?: OutputsType;
}
/**
 * @public
 */
export declare function dynamicDirectiveDef<T>(type: Type<T>, inputs?: InputsType, outputs?: OutputsType): DynamicDirectiveDef<T>;
/**
 * @public
 */
export interface DirectiveRef<T> {
    instance: T;
    type: Type<T>;
    injector: Injector;
    hostComponent: unknown;
    hostView: ViewRef;
    location: ElementRef;
    changeDetectorRef: ChangeDetectorRef;
    onDestroy: (callback: Function) => void;
}
/**
 * @public
 * @experimental Dynamic directives is an experimental API that may not work as expected.
 *
 * NOTE: There is a known issue with OnChanges hook not beign triggered on dynamic directives
 * since this part of functionality has been removed from the core as Angular now
 * supports this out of the box for dynamic components.
 */
export declare class DynamicDirectivesDirective implements OnDestroy, DoCheck {
    private injector;
    private iterableDiffers;
    private ioFactoryService;
    private reflectService;
    private componentInjector?;
    ndcDynamicDirectives?: DynamicDirectiveDef<unknown>[] | null;
    ngComponentOutletNdcDynamicDirectives?: DynamicDirectiveDef<unknown>[] | null;
    ndcDynamicDirectivesCreated: EventEmitter<DirectiveRef<unknown>[]>;
    private lastCompInstance;
    private get directives();
    private get componentRef();
    private get compInstance();
    private get isCompChanged();
    private get hostInjector();
    private dirRef;
    private dirIo;
    private dirsDiffer;
    constructor(injector: Injector, iterableDiffers: IterableDiffers, ioFactoryService: IoFactoryService, reflectService: ReflectService, componentInjector?: DynamicComponentInjector | undefined);
    ngDoCheck(): void;
    ngOnDestroy(): void;
    private maybeDestroyDirectives;
    private processDirChanges;
    private updateDirectives;
    private updateDirective;
    private initDirective;
    private destroyAllDirectives;
    private destroyDirective;
    private initDirIO;
    private dirToCompDef;
    private destroyDirRef;
    private createDirective;
    private resolveDirParamTypes;
    private callInitHooks;
    private callHook;
    static ɵfac: i0.ɵɵFactoryDeclaration<DynamicDirectivesDirective, [null, null, null, null, { optional: true; }]>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<DynamicDirectivesDirective, "[ndcDynamicDirectives],[ngComponentOutletNdcDynamicDirectives]", never, { "ndcDynamicDirectives": "ndcDynamicDirectives"; "ngComponentOutletNdcDynamicDirectives": "ngComponentOutletNdcDynamicDirectives"; }, { "ndcDynamicDirectivesCreated": "ndcDynamicDirectivesCreated"; }, never, never, true>;
}
//# sourceMappingURL=dynamic-directives.directive.d.ts.map