import { ChangeDetectorRef, ComponentFactoryResolver, Injector, KeyValueDiffers, OnDestroy, StaticProvider } from '@angular/core';
import { DynamicComponentInjector } from '../component-injector';
import { InputsType, OutputsType } from './types';
import * as i0 from "@angular/core";
/**
 * @public
 */
export declare class IoServiceOptions {
    trackOutputChanges: boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<IoServiceOptions, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<IoServiceOptions>;
}
/**
 * @public
 */
export declare class IoService implements OnDestroy {
    private injector;
    private differs;
    private cfr;
    private options;
    private compInjector;
    private eventArgument;
    private cdr;
    private eventContextProvider;
    private lastComponentInst;
    private lastChangedInputs;
    private inputsDiffer;
    private compFactory;
    private outputsShouldDisconnect$;
    private outputsEventContext;
    private inputs;
    private outputs;
    private outputsChanged;
    private get compRef();
    private get componentInst();
    private get componentInstChanged();
    constructor(injector: Injector, differs: KeyValueDiffers, cfr: ComponentFactoryResolver, options: IoServiceOptions, compInjector: DynamicComponentInjector, eventArgument: string, cdr: ChangeDetectorRef, eventContextProvider: StaticProvider);
    ngOnDestroy(): void;
    /**
     * Call update whenever inputs/outputs may or did change.
     *
     * It will detect both new and mutated changes.
     */
    update(inputs?: InputsType | null, outputs?: OutputsType | null): void;
    private updateIO;
    private updateInputs;
    private bindOutputs;
    private disconnectOutputs;
    private getInputsChanges;
    private updateChangedInputs;
    private resolveCompFactory;
    private updateCompFactory;
    private resolveOutputs;
    private updateOutputsEventContext;
    private processOutputs;
    private processOutputArgs;
    private remapIO;
    private findPropByTplInMapping;
    static ɵfac: i0.ɵɵFactoryDeclaration<IoService, [null, null, null, null, null, null, null, { optional: true; }]>;
    static ɵprov: i0.ɵɵInjectableDeclaration<IoService>;
}
//# sourceMappingURL=io.service.d.ts.map