"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultTsConfigPath = void 0;
exports.initializeTsConfig = initializeTsConfig;
exports.setDependenciesTsConfigPaths = setDependenciesTsConfigPaths;
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const load_esm_1 = require("../utils/load-esm");
const log = __importStar(require("../utils/log"));
exports.defaultTsConfigPath = path.join(__dirname, 'conf', 'tsconfig.ngc.json');
/**
 * Reads the default TypeScript configuration.
 */
async function readDefaultTsConfig(fileName = exports.defaultTsConfigPath) {
    // these options are mandatory
    const extraOptions = {
        target: typescript_1.default.ScriptTarget.ES2022,
        // sourcemaps
        sourceMap: false,
        inlineSources: true,
        inlineSourceMap: true,
        outDir: '',
        declaration: true,
        // ng compiler
        enableResourceInlining: true,
        // these are required to set the appropriate EmitFlags
        flatModuleId: 'AUTOGENERATED',
        flatModuleOutFile: 'AUTOGENERATED',
    };
    const { readConfiguration } = await (0, load_esm_1.ngCompilerCli)();
    return readConfiguration(fileName, extraOptions);
}
/**
 * Creates a parsed TypeScript configuration object.
 *
 * @param values File path or parsed configuration.
 */
async function createDefaultTsConfig(values) {
    if (!values) {
        return readDefaultTsConfig();
    }
    else if (typeof values === 'string') {
        return readDefaultTsConfig(values);
    }
    else {
        return values;
    }
}
/**
 * Initializes TypeScript Compiler options and Angular Compiler options by overriding the
 * default config with entry point-specific values.
 */
async function initializeTsConfig(defaultTsConfig, entryPoints) {
    const defaultTsConfigParsed = await createDefaultTsConfig(defaultTsConfig);
    if (defaultTsConfigParsed.errors.length > 0) {
        const { formatDiagnostics } = await (0, load_esm_1.ngCompilerCli)();
        throw new Error(formatDiagnostics(defaultTsConfigParsed.errors));
    }
    entryPoints.forEach(currentEntryPoint => {
        const { entryPoint } = currentEntryPoint.data;
        log.debug(`Initializing tsconfig for ${entryPoint.moduleId}`);
        const basePath = path.dirname(entryPoint.entryFilePath);
        // Resolve defaults from DI token and create a deep copy of the defaults
        const tsConfig = JSON.parse(JSON.stringify(defaultTsConfigParsed));
        const overrideOptions = {
            flatModuleId: entryPoint.moduleId,
            flatModuleOutFile: `${entryPoint.flatModuleFile}.js`,
            basePath,
            rootDir: basePath,
            sourceRoot: '',
        };
        tsConfig.rootNames = [entryPoint.entryFilePath];
        tsConfig.options = { ...tsConfig.options, ...overrideOptions };
        currentEntryPoint.data.tsConfig = tsConfig;
    });
}
/**
 * Set the paths for entrypoint dependencies.
 *
 * This doesn't mutate the object.
 *
 * @param parsedTsConfig - A parsed tsconfig
 * @param entryPoints - A list of entryPoints
 * @param pointToSource Point the path mapping to either the source code or emitted declarations.
 * Typically for analysis one should point to the source files while for a compilation once should use the emitted declarations
 */
function setDependenciesTsConfigPaths(parsedTsConfig, entryPoints, pointToSource = false) {
    const tsConfig = JSON.parse(JSON.stringify(parsedTsConfig));
    // Add paths mappings for dependencies
    if (!tsConfig.options.paths) {
        tsConfig.options.paths = {};
    }
    for (const dep of entryPoints) {
        const { entryPoint } = dep.data;
        const { moduleId, destinationFiles, entryFilePath } = entryPoint;
        const mappedPath = [pointToSource ? entryFilePath : destinationFiles.declarations];
        if (!tsConfig.options.paths[moduleId]) {
            tsConfig.options.paths[moduleId] = mappedPath;
        }
        else {
            tsConfig.options.paths[moduleId].unshift(...mappedPath);
        }
    }
    return tsConfig;
}
//# sourceMappingURL=tsconfig.js.map