"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const workspace_1 = require("../utils/workspace");
function addNgxBuildPlus(_options) {
    return (tree, _context) => {
        const project = _options.project;
        const workspace = workspace_1.getWorkspace(tree);
        const architect = workspace.projects[project].architect;
        if (!architect)
            throw new Error(`expected node projects/${project}/architect in angular.json`);
        const build = architect.build;
        if (!build)
            throw new Error(`expected node projects/${project}/architect/build in angular.json`);
        if (!_options.noWarning && build.builder === '@angular-devkit/build-angular:application') {
            console.warn(`\nWARNING: ngx-build plus uses Angular\'s tradational webpack builder and not the fast new esbuild-based ApplicationBuilder.\n`);
        }
        // Custom Builders are not part of the CLI's enum
        build.builder = 'ngx-build-plus:browser';
        downgradeToWebpack(build);
        const serve = architect.serve;
        if (!serve)
            throw new Error(`expected node projects/${project}/architect/serve in angular.json`);
        serve.builder = 'ngx-build-plus:dev-server';
        const extractI18n = architect['extract-i18n'];
        if (extractI18n) {
            extractI18n.builder = 'ngx-build-plus:extract-i18n';
        }
        // We decided to not add our server builder by default, 
        // b/c the new jsdom-based Universal API only compiles
        // the server code (that is using the browser bundles) 
        // with this builder.
        //
        // const server = architect.server;
        // if (server) {
        //   server.builder = <any>'ngx-build-plus:server';
        // }
        const test = architect.test;
        if (test)
            test.builder = 'ngx-build-plus:karma';
        return workspace_1.updateWorkspace(tree, workspace);
    };
}
exports.addNgxBuildPlus = addNgxBuildPlus;
function downgradeToWebpack(build) {
    if (!build.options) {
        return;
    }
    if (build.options.browser) {
        build.options.main = build.options.browser;
        delete build.options.browser;
    }
    if (!build.options.assets) {
        return;
    }
    for (const asset of build.options.assets) {
        if (typeof asset === 'object' && typeof asset.output === 'undefined') {
            asset.output = '.';
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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