"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const workspace_1 = require("../utils/workspace");
const path = require("path");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const SCRIPTS = [
    "node_modules/rxjs/bundles/rxjs.umd.js",
    "node_modules/@angular/core/bundles/core.umd.js",
    "node_modules/@angular/common/bundles/common.umd.js",
    "node_modules/@angular/common/bundles/common-http.umd.js",
    "node_modules/@angular/compiler/bundles/compiler.umd.js",
    "node_modules/@angular/elements/bundles/elements.umd.js",
    "node_modules/@angular/platform-browser/bundles/platform-browser.umd.js",
    "node_modules/@angular/platform-browser-dynamic/bundles/platform-browser-dynamic.umd.js"
];
function addExternalsSupport(_options) {
    return (tree, _context) => {
        const project = getProject(tree, _options);
        const relProjectRootPath = project.root.replace(/[^\/]+/g, '..') || '';
        updatePackageJson(project.root || '', tree, _options, _context);
        const templateSource = schematics_1.apply(schematics_1.url('./files'), [
            schematics_1.template(Object.assign(Object.assign({}, _options), { relProjectRootPath, projectRoot: project.root || '' })),
            schematics_1.move(project.root || '/')
        ]);
        return schematics_1.chain([
            addScriptsToProject(tree, _options),
            schematics_1.mergeWith(templateSource),
        ]);
    };
}
exports.addExternalsSupport = addExternalsSupport;
function updatePackageJson(path, tree, _options, _context) {
    const config = loadPackageJson(tree);
    updateScripts(path, config, tree, _options, _context);
    savePackageJson(config, tree);
}
function addScriptsToProject(tree, options) {
    const workspace = workspace_1.getWorkspace(tree);
    if (!options.project) {
        options.project = Object.keys(workspace.projects)[0];
    }
    const project = workspace.projects[options.project];
    if (!project.architect || !project.architect.build || !project.architect.build.options) {
        return schematics_1.noop();
    }
    const buildOptions = project.architect.build.options;
    if (!buildOptions)
        return schematics_1.noop();
    if (!buildOptions.scripts) {
        buildOptions.scripts = [];
    }
    const scripts = buildOptions.scripts;
    SCRIPTS
        .filter(s => !scripts.includes(s))
        .forEach(script => {
        scripts.push(script);
    });
    workspace_1.updateWorkspace(tree, workspace);
    return schematics_1.noop();
}
function getProject(tree, options) {
    const workspace = workspace_1.getWorkspace(tree);
    if (!options.project) {
        options.project = Object.keys(workspace.projects)[0];
    }
    const project = workspace.projects[options.project];
    // compensate for lacking sourceRoot property
    // e. g. when project was migrated to ng7, sourceRoot is lacking
    if (!project.sourceRoot && !project.root) {
        project.sourceRoot = 'src';
    }
    else if (!project.sourceRoot) {
        project.sourceRoot = path.join(project.root, 'src');
    }
    return project;
}
function savePackageJson(config, tree) {
    const newContentAsString = JSON.stringify(config, null, 2) || '';
    tree.overwrite('package.json', newContentAsString);
}
function loadPackageJson(tree) {
    const pkg = tree.read('package.json');
    if (pkg === null)
        throw Error('could not read package.json');
    const contentAsString = pkg.toString('UTF-8');
    const config = JSON.parse(contentAsString);
    return config;
}
function updateScripts(path, config, tree, _options, _context) {
    const project = getProject(tree, _options);
    if (path)
        path += '/';
    if (!config['scripts']) {
        config.scripts = {};
    }
    let additionalFlags = '';
    // Ivy support
    const postInstall = config.scripts['postinstall'] || '';
    //if (postInstall.startsWith('ngcc')) {
    config.scripts['postinstall:bak'] = postInstall;
    config.scripts['postinstall'] = 'ngcc';
    _context.addTask(new tasks_1.RunSchematicTask('npmRun', { script: 'postinstall' }));
    //} 
    if (!_options.host) {
        // external web components need single bundle 
        additionalFlags = '--single-bundle';
    }
    // Heuristic for default project
    if (!project.root) {
        config.scripts['build:externals'] = `ng build --extra-webpack-config ${path}/webpack.externals.js --prod ${additionalFlags}`;
    }
    if (_options.project) {
        config.scripts[`build:${_options.project}:externals`] = `ng build --extra-webpack-config ${path}/webpack.externals.js --prod --project ${_options.project} ${additionalFlags}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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