"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const workspace_1 = require("../utils/workspace");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const spawn = require('cross-spawn');
// function npmInstall(options: any): Rule {
//   return function (tree: Tree, context: SchematicContext) {
//     spawn.sync('npm', ['install', options.package, options.switch], { stdio: 'inherit' });
//     return tree;
//   }
// }
function npmRun(options) {
    return function (tree, context) {
        spawn.sync('npm', ['run', options.script], { stdio: 'inherit' });
        return tree;
    };
}
exports.npmRun = npmRun;
function addWebComponentsPolyfill(_options) {
    return (tree, _context) => {
        const packageJson = loadPackageJson(tree);
        if (!packageJson['dependencies'] || !packageJson['dependencies']['@webcomponents/webcomponentsjs']) {
            _context.addTask(new tasks_1.NodePackageInstallTask({
                packageName: '@webcomponents/webcomponentsjs',
            }));
        }
        return schematics_1.chain([
            addScriptsToProject(tree, _options)
        ]);
    };
}
exports.addWebComponentsPolyfill = addWebComponentsPolyfill;
function addScriptsToProject(tree, options) {
    const workspace = workspace_1.getWorkspace(tree);
    if (!options.project) {
        options.project = Object.keys(workspace.projects)[0];
    }
    const project = workspace.projects[options.project];
    if (!project.architect || !project.architect.build || !project.architect.build.options) {
        return schematics_1.noop();
    }
    const buildOptions = project.architect.build.options;
    if (!buildOptions)
        return schematics_1.noop();
    if (!buildOptions.scripts) {
        buildOptions.scripts = [];
    }
    const scripts = buildOptions.scripts;
    if (!scripts.find(s => s.bundleName === 'polyfill-webcomp-es5')) {
        scripts.push({
            bundleName: 'polyfill-webcomp-es5',
            input: 'node_modules/@webcomponents/webcomponentsjs/custom-elements-es5-adapter.js'
        });
    }
    if (!scripts.find(s => s.bundleName === 'polyfill-webcomp')) {
        scripts.push({
            bundleName: 'polyfill-webcomp',
            input: 'node_modules/@webcomponents/webcomponentsjs/bundles/webcomponents-sd-ce-pf.js'
        });
    }
    workspace_1.updateWorkspace(tree, workspace);
    return schematics_1.noop();
}
function loadPackageJson(tree) {
    const pkg = tree.read('package.json');
    if (pkg === null)
        throw Error('could not read package.json');
    const contentAsString = pkg.toString('UTF-8');
    const config = JSON.parse(contentAsString);
    return config;
}
//# sourceMappingURL=data:application/json;base64,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