"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const { bold, green, red, reset, white, yellow } = core_1.terminal;
function formatSize(size) {
    if (size <= 0) {
        return '0 bytes';
    }
    const abbreviations = ['bytes', 'kB', 'MB', 'GB'];
    const index = Math.floor(Math.log(size) / Math.log(1024));
    return `${+(size / Math.pow(1024, index)).toPrecision(3)} ${abbreviations[index]}`;
}
exports.formatSize = formatSize;
function statsToString(json, statsConfig = {}) {
    const colors = statsConfig.colors;
    const rs = (x) => colors ? reset(x) : x;
    const w = (x) => colors ? bold(white(x)) : x;
    const g = (x) => colors ? bold(green(x)) : x;
    const y = (x) => colors ? bold(yellow(x)) : x;
    if (!json.chunks) {
        return '\n' + rs(core_1.tags.stripIndents `
    ${g('Successfully builded your bundles!')}
    Date: ${w(new Date().toISOString())}
    Hash: ${w(json.hash)}`);
    }
    const changedChunksStats = json.chunks
        .filter((chunk) => chunk.rendered)
        .map((chunk) => {
        const asset = json.assets.filter((x) => x.name == chunk.files[0])[0];
        const size = asset ? ` ${formatSize(asset.size)}` : '';
        const files = chunk.files.join(', ');
        const names = chunk.names ? ` (${chunk.names.join(', ')})` : '';
        const initial = y(chunk.entry ? '[entry]' : chunk.initial ? '[initial]' : '');
        const flags = ['rendered', 'recorded']
            .map(f => f && chunk[f] ? g(` [${f}]`) : '')
            .join('');
        return `chunk {${y(chunk.id)}} ${g(files)}${names}${size} ${initial}${flags}`;
    });
    const unchangedChunkNumber = json.chunks.length - changedChunksStats.length;
    if (unchangedChunkNumber > 0) {
        return '\n' + rs(core_1.tags.stripIndents `
      Date: ${w(new Date().toISOString())} - Hash: ${w(json.hash)} - Time: ${w('' + json.time)}ms
      ${unchangedChunkNumber} unchanged chunks
      ${changedChunksStats.join('\n')}
      `);
    }
    else {
        return '\n' + rs(core_1.tags.stripIndents `
      Date: ${w(new Date().toISOString())}
      Hash: ${w(json.hash)}
      Time: ${w('' + json.time)}ms
      ${changedChunksStats.join('\n')}
      `);
    }
}
exports.statsToString = statsToString;
function statsWarningsToString(json, statsConfig) {
    const colors = statsConfig.colors;
    const rs = (x) => colors ? reset(x) : x;
    const y = (x) => colors ? bold(yellow(x)) : x;
    return rs('\n' + json.warnings.map((warning) => y(`WARNING in ${warning}`)).join('\n\n'));
}
exports.statsWarningsToString = statsWarningsToString;
function statsErrorsToString(json, statsConfig) {
    const colors = statsConfig.colors;
    const rs = (x) => colors ? reset(x) : x;
    const r = (x) => colors ? bold(red(x)) : x;
    return rs('\n' + json.errors.map((error) => r(`ERROR in ${error}`)).join('\n'));
}
exports.statsErrorsToString = statsErrorsToString;
//# sourceMappingURL=data:application/json;base64,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