"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const load_hook_1 = require("../ext/load-hook");
const core_1 = require("@angular-devkit/core");
const path = require("path");
const webpack_merge_1 = require("webpack-merge");
function runBuilderHandler(options, transforms, context, builderHandler, configTransformerName = 'webpackConfiguration') {
    let plugin = null;
    if (options.plugin) {
        plugin = load_hook_1.loadHook(options.plugin);
    }
    setupConfigHook(transforms, options, context, plugin, configTransformerName);
    if (plugin && plugin.pre) {
        plugin.pre(options);
    }
    const result = asObservable(builderHandler(options, context, transforms));
    return result.pipe(operators_1.tap(_ => {
        if (plugin && plugin.post) {
            plugin.post(options);
        }
    }));
}
exports.runBuilderHandler = runBuilderHandler;
function asObservable(result) {
    if (rxjs_1.isObservable(result)) {
        return result;
    }
    if (result instanceof Promise) {
        return rxjs_1.from(result);
    }
    return rxjs_1.of(result);
}
function setupConfigHook(transforms, options, context, plugin, configTransformerName = 'webpackConfiguration') {
    const originalConfigFn = transforms[configTransformerName];
    transforms[configTransformerName] = (config) => {
        if (options.singleBundle) {
            if (!options.keepPolyfills && config.entry && config.entry['polyfills']) {
                delete config.entry['polyfills'];
            }
            if (!options.keepPolyfills && config.entry && config.entry['polyfills-es5']) {
                delete config.entry['polyfills-es5'];
            }
            if (config.optimization) {
                delete config.optimization.runtimeChunk;
                delete config.optimization.splitChunks;
            }
        }
        const keepStyles = !options.bundleStyles || options.keepStyles;
        if (options.singleBundle && !keepStyles && config.entry && config.entry['styles']) {
            delete config.entry['styles'];
        }
        if (options.extraWebpackConfig) {
            const filePath = path.resolve(core_1.getSystemPath(core_1.normalize(context.workspaceRoot)), options.extraWebpackConfig);
            const additionalConfig = require(filePath);
            config = webpack_merge_1.merge([config, additionalConfig]);
        }
        if (plugin && plugin.config) {
            config = plugin.config(config, options);
        }
        if (options.configHook) {
            const hook = load_hook_1.loadHook(options.configHook);
            config = hook(config);
        }
        if (originalConfigFn) {
            return originalConfigFn(config);
        }
        else {
            return config;
        }
    };
}
//# sourceMappingURL=data:application/json;base64,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