"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleActivatePowerpack = handleActivatePowerpack;
const workspace_root_1 = require("../../utils/workspace-root");
const enquirer_1 = require("enquirer");
const child_process_1 = require("child_process");
const package_manager_1 = require("../../utils/package-manager");
async function handleActivatePowerpack(options) {
    const license = options.license ??
        (await (0, enquirer_1.prompt)({
            type: 'input',
            name: 'license',
            message: 'Enter your License Key',
        }));
    const { activatePowerpack } = await requirePowerpack();
    activatePowerpack(workspace_root_1.workspaceRoot, license);
}
async function requirePowerpack() {
    // @ts-ignore
    return Promise.resolve().then(() => require('@nx/powerpack-license')).catch(async (e) => {
        if ('code' in e && e.code === 'MODULE_NOT_FOUND') {
            try {
                (0, child_process_1.execSync)(`${(0, package_manager_1.getPackageManagerCommand)().addDev} @nx/powerpack-license@latest`, {
                    windowsHide: true,
                });
                // @ts-ignore
                return await Promise.resolve().then(() => require('@nx/powerpack-license'));
            }
            catch (e) {
                throw new Error('Failed to install @nx/powerpack-license. Please install @nx/powerpack-license and try again.');
            }
        }
    });
}
