/**
 * This function is used to get the implementation factory of an executor or generator.
 * @param implementation path to the implementation
 * @param directory path to the directory
 * @returns a function that returns the implementation
 */
export declare function getImplementationFactory<T>(implementation: string, directory: string): () => T;
/**
 * This function is used to resolve the implementation of an executor or generator.
 * @param implementationModulePath
 * @param directory
 * @returns path to the implementation
 */
export declare function resolveImplementation(implementationModulePath: string, directory: string): string;
export declare function resolveSchema(schemaPath: string, directory: string): string;
