"use strict";
/**
 * This is a copy of the @nx/devkit utility but this should not be used outside of the nx package
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertNxExecutor = convertNxExecutor;
const nx_json_1 = require("../../config/nx-json");
const retrieve_workspace_files_1 = require("../../project-graph/utils/retrieve-workspace-files");
const project_configuration_utils_1 = require("../../project-graph/utils/project-configuration-utils");
const get_plugins_1 = require("../../project-graph/plugins/get-plugins");
/**
 * Convert an Nx Executor into an Angular Devkit Builder
 *
 * Use this to expose a compatible Angular Builder
 */
function convertNxExecutor(executor) {
    const builderFunction = (options, builderContext) => {
        const promise = async () => {
            const nxJsonConfiguration = (0, nx_json_1.readNxJson)(builderContext.workspaceRoot);
            const plugins = await (0, get_plugins_1.getPlugins)();
            const projectsConfigurations = {
                version: 2,
                projects: (0, project_configuration_utils_1.readProjectConfigurationsFromRootMap)((await (0, retrieve_workspace_files_1.retrieveProjectConfigurations)(plugins, builderContext.workspaceRoot, nxJsonConfiguration)).projects),
            };
            const context = {
                root: builderContext.workspaceRoot,
                projectName: builderContext.target.project,
                targetName: builderContext.target.target,
                target: builderContext.target.target,
                configurationName: builderContext.target.configuration,
                workspace: { ...nxJsonConfiguration, ...projectsConfigurations },
                projectsConfigurations,
                nxJsonConfiguration,
                cwd: process.cwd(),
                projectGraph: null,
                taskGraph: null,
                isVerbose: false,
            };
            return executor(options, context);
        };
        return toObservable(promise());
    };
    return require('@angular-devkit/architect').createBuilder(builderFunction);
}
function toObservable(promiseOrAsyncIterator) {
    return new (require('rxjs').Observable)((subscriber) => {
        promiseOrAsyncIterator
            .then((value) => {
            if (!value.next) {
                subscriber.next(value);
                subscriber.complete();
            }
            else {
                let asyncIterator = value;
                function recurse(iterator) {
                    iterator
                        .next()
                        .then((result) => {
                        if (!result.done) {
                            subscriber.next(result.value);
                            recurse(iterator);
                        }
                        else {
                            if (result.value) {
                                subscriber.next(result.value);
                            }
                            subscriber.complete();
                        }
                    })
                        .catch((e) => {
                        subscriber.error(e);
                    });
                }
                recurse(asyncIterator);
                return () => {
                    asyncIterator.return();
                };
            }
        })
            .catch((err) => {
            subscriber.error(err);
        });
    });
}
