import { NxJsonConfiguration } from '../config/nx-json';
import { FileData, FileMap, ProjectGraph } from '../config/project-graph';
import { ProjectConfiguration } from '../config/workspace-json-project-json';
export interface FileMapCache {
    version: string;
    nxVersion: string;
    deps: Record<string, string>;
    pathMappings: Record<string, any>;
    nxJsonPlugins: PluginData[];
    pluginsConfig?: any;
    fileMap: FileMap;
}
export declare const nxProjectGraph: string;
export declare const nxFileMap: string;
export declare function ensureCacheDirectory(): void;
export declare function readFileMapCache(): null | FileMapCache;
export declare function readProjectGraphCache(): null | ProjectGraph;
export declare function createProjectFileMapCache(nxJson: NxJsonConfiguration<'*' | string[]>, packageJsonDeps: Record<string, string>, fileMap: FileMap, tsConfig: {
    compilerOptions?: {
        paths?: {
            [p: string]: any;
        };
    };
}): FileMapCache;
export declare function writeCache(cache: FileMapCache, projectGraph: ProjectGraph): void;
export declare function shouldRecomputeWholeGraph(cache: FileMapCache, packageJsonDeps: Record<string, string>, projects: Record<string, ProjectConfiguration>, nxJson: NxJsonConfiguration, tsConfig: {
    compilerOptions: {
        paths: {
            [k: string]: any;
        };
    };
}): boolean;
export type CachedFileData = {
    nonProjectFiles: Record<string, FileData>;
    projectFileMap: {
        [project: string]: Record<string, FileData>;
    };
};
export declare function extractCachedFileData(fileMap: FileMap, c: FileMapCache): {
    filesToProcess: FileMap;
    cachedFileData: CachedFileData;
};
type PluginData = {
    name: string;
    version: string;
    options?: unknown;
};
export {};
