import { ProjectConfiguration } from '../../config/workspace-json-project-json';
import { PackageJson } from '../../utils/package-json';
import type { PluginConfiguration } from '../../config/nx-json';
import { LoadedNxPlugin } from './internal-api';
export declare function readPluginPackageJson(pluginName: string, projects: Record<string, ProjectConfiguration>, paths?: string[]): {
    path: string;
    json: PackageJson;
};
export declare function resolveLocalNxPlugin(importPath: string, projects: Record<string, ProjectConfiguration>, root?: string): {
    path: string;
    projectConfig: ProjectConfiguration;
} | null;
export declare let unregisterPluginTSTranspiler: (() => void) | null;
/**
 * Register swc-node or ts-node if they are not currently registered
 * with some default settings which work well for Nx plugins.
 */
export declare function registerPluginTSTranspiler(): void;
export declare function getPluginPathAndName(moduleName: string, paths: string[], projects: Record<string, ProjectConfiguration>, root: string): {
    pluginPath: string;
    name: any;
};
export declare function loadNxPlugin(plugin: PluginConfiguration, root: string): readonly [Promise<LoadedNxPlugin>, () => void];
export declare function loadNxPluginAsync(pluginConfiguration: PluginConfiguration, paths: string[], root: string): Promise<LoadedNxPlugin>;
