import { DefaultTasksRunnerOptions, RemoteCache } from './default-tasks-runner';
import { Task } from '../config/task-graph';
import { NxJsonConfiguration } from '../config/nx-json';
export type CachedResult = {
    terminalOutput: string;
    outputsPath: string;
    code: number;
    remote: boolean;
};
export type TaskWithCachedResult = {
    task: Task;
    cachedResult: CachedResult;
};
export declare function dbCacheEnabled(nxJson?: NxJsonConfiguration): boolean;
export declare function getCache(options: DefaultTasksRunnerOptions): DbCache | Cache;
export declare class DbCache {
    private readonly options;
    private cache;
    private remoteCache;
    private remoteCachePromise;
    private isVerbose;
    constructor(options: {
        nxCloudRemoteCache: RemoteCache;
    });
    init(): Promise<void>;
    get(task: Task): Promise<CachedResult | null>;
    private applyRemoteCacheResults;
    put(task: Task, terminalOutput: string | null, outputs: string[], code: number): Promise<void>;
    copyFilesFromCache(_: string, cachedResult: CachedResult, outputs: string[]): Promise<void>;
    removeOldCacheRecords(): void;
    temporaryOutputPath(task: Task): string;
    private getRemoteCache;
    private _getRemoteCache;
    private getPowerpackS3Cache;
    private getPowerpackSharedCache;
    private getPowerpackCache;
    private resolvePackage;
    private assertCacheIsValid;
}
/**
 * @deprecated Use the {@link DbCache} class instead. This will be removed in Nx 21.
 */
export declare class Cache {
    private readonly options;
    root: string;
    cachePath: string;
    terminalOutputsDir: string;
    private _currentMachineId;
    constructor(options: DefaultTasksRunnerOptions);
    removeOldCacheRecords(): void;
    currentMachineId(): Promise<string>;
    get(task: Task): Promise<CachedResult | null>;
    put(task: Task, terminalOutput: string | null, outputs: string[], code: number): Promise<void>;
    copyFilesFromCache(hash: string, cachedResult: CachedResult, outputs: string[]): Promise<void>;
    temporaryOutputPath(task: Task): string;
    private expandOutputsInWorkspace;
    private expandOutputsInCache;
    private _expandOutputs;
    private copy;
    private remove;
    private getFromLocalDir;
    private assertLocalCacheValidity;
    private createCacheDir;
    private createTerminalOutputsDir;
}
