"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NxPowerpackNotInstalledError = void 0;
exports.printPowerpackLicense = printPowerpackLicense;
exports.getPowerpackLicenseInformation = getPowerpackLicenseInformation;
const logger_1 = require("./logger");
const package_manager_1 = require("./package-manager");
const workspace_root_1 = require("./workspace-root");
async function printPowerpackLicense() {
    try {
        const { organizationName, seatCount, workspaceCount } = await getPowerpackLicenseInformation();
        logger_1.logger.log(`Nx Powerpack Licensed to ${organizationName} for ${seatCount} user${seatCount > 1 ? '' : 's'} in ${workspaceCount === 9999 ? 'an unlimited number of' : workspaceCount} workspace${workspaceCount > 1 ? '' : 's'}`);
    }
    catch { }
}
async function getPowerpackLicenseInformation() {
    try {
        const { getPowerpackLicenseInformation } = (await Promise.resolve().then(() => require('@nx/powerpack-license')));
        return getPowerpackLicenseInformation(workspace_root_1.workspaceRoot);
    }
    catch (e) {
        if ('code' in e && e.code === 'MODULE_NOT_FOUND') {
            throw new NxPowerpackNotInstalledError(e);
        }
        throw e;
    }
}
class NxPowerpackNotInstalledError extends Error {
    constructor(e) {
        super(`The "@nx/powerpack-license" package is needed to use Nx Powerpack enabled features. Please install the @nx/powerpack-license with ${(0, package_manager_1.getPackageManagerCommand)().addDev} @nx/powerpack-license`, { cause: e });
    }
}
exports.NxPowerpackNotInstalledError = NxPowerpackNotInstalledError;
